class MessageQueue{constructor(){this.queue=[],this.processing=!1,this.handler=null,
// 添加超时时间配置，默认为4秒
this.timeout=6e4,// 毫秒
this.defaultRequestOptions={method:"POST",url:"https://example.com",headers:{"Content-Type":"application/json",Accept:"application/json"}}}
// 设置超时时间（可选，默认4秒）
setTimeout(timeoutMs){if(!("number"==typeof timeoutMs&&0<timeoutMs))throw new Error("Timeout must be a positive number");this.timeout=timeoutMs}setHandler(handler){if("function"!=typeof handler)throw new Error("Handler must be a function");this.handler=handler}setRequestOptions(options){this.defaultRequestOptions={...this.defaultRequestOptions,...options,headers:{...this.defaultRequestOptions.headers,...options.headers}}}hasMessageWithCode(code){return this.queue.some(item=>item.options.headers&&item.options.headers.code===code)}enqueue(message,options={}){let mergedOptions={...this.defaultRequestOptions,...options,headers:{...this.defaultRequestOptions.headers,...options.headers}};options=mergedOptions.headers.code;return options&&this.hasMessageWithCode(options)?Promise.reject(new Error("重复的消息code: "+options)):new Promise((resolve,reject)=>{resolve={body:message,options:mergedOptions,resolve:resolve,reject:reject};this.queue.push(resolve),this.processing||this.processNext()})}async processNext(){if(0!==this.queue.length&&this.handler){this.processing=!0;var{body,options,resolve,reject}=this.queue.shift();
// 添加调试日志
try{resolve(await Promise.race([
// 正常处理请求
this.handler(body,options),
// 超时Promise
new Promise((_,timeoutReject)=>{setTimeout(()=>{timeoutReject(new Error(`请求超时（超过${this.timeout/1e3}秒）`))},this.timeout)})]))}catch(error){reject(error)}finally{this.processNext()}}else this.processing=!1}getLength(){return this.queue.length}clear(){this.queue=[]}replaceMessage(message,options={}){options={...this.defaultRequestOptions,...options,headers:{...this.defaultRequestOptions.headers,...options.headers}};let code=options.headers.code;if(!code)throw new Error("replaceMessage requires a code in headers");var index=this.queue.findIndex(item=>item.options.headers&&item.options.headers.code===code);-1!==index?this.queue.splice(index,1,{body:message,options:options,resolve:result=>{},// 占位，实际使用时会被替换
reject:error=>{}// 占位，实际使用时会被替换
}):this.queue.push({body:message,options:options,resolve:result=>{},reject:error=>{}}),this.processing||this.processNext()}}